' RS_LINE.BAS

Option Explicit

Dim FatalFlag As Integer
Dim Code As Integer

Sub Aborting ()
  Dim Code As Integer
  MODEM.Print "Fatal Error, Aborting..."
  Code = SioDone(ThePort)
  End
End Sub

Sub GetIncoming ()
  Dim i As Integer
  Dim Buffer As String * 1024
  Dim Count As Integer
  Count = SioGets(ThePort, Buffer, 1024)
  If Count > 0 Then
    For i = 1 To Count
      Call DisplayChar(MODEM, Asc(Mid$(Buffer, i, 1)))
    Next i
  End If
End Sub

Sub GoOffLine ()
  Dim Code As Integer
  MODEM.menuPort.Enabled = True
  MODEM.menuStatus.Enabled = False
  MODEM.menuControl.Enabled = False
  MODEM.menuFlow.Enabled = False
  OnLineFlag = 0
  'shut down port
  Code = SioDone(ThePort)
End Sub

Sub GoOnLine ()
  Dim i As Integer
  Dim RxQueSize As Integer
  Dim TxQueSize As Integer
  If OnLineFlag Then
    Exit Sub
  End If
  'reset the port (1024 byte RX buffer & 512 byte TX buffer)
  RxQueSize = 1024
  TxQueSize = 512
  Code = SioReset(ThePort, RxQueSize, TxQueSize)
  If Code < 0 Then
    Call SayError(MODEM, Code)
    Exit Sub
  End If
  'set baud rate
  Code = SioBaud(ThePort, TheBaudCode)
  'call Aborting() if detect error after resetting port
  Call DisplayLine(MODEM, "[COM" + LTrim$(Str$(1 + ThePort)) + " reset]")
  ' set parms
  Code = SioParms(ThePort, TheParity, TheStopBits, TheDataBits)
  'set DTR
  Code = SioDTR(ThePort, Asc("S"))
  MODEM.menuSetDTR.Enabled = False
  MODEM.menuSetDTR.Checked = True
  MODEM.menuClearDTR.Enabled = True
  MODEM.menuClearDTR.Checked = False
  'set RTS
  Code = SioRTS(ThePort, Asc("S"))
  MODEM.menuSetRTS.Enabled = False
  MODEM.menuSetRTS.Checked = True
  MODEM.menuClearRTS.Enabled = True
  MODEM.menuClearRTS.Checked = False
  ' we're online !
  OnLineFlag = 1
  MODEM.menuPort.Enabled = False
  MODEM.menuStatus.Enabled = True
  MODEM.menuControl.Enabled = True
  MODEM.menuFlow.Enabled = True
End Sub

Sub SetBaud ()
Dim Code As Integer
'Baudrate can be changed while running
Code = SioBaud(ThePort, TheBaudCode)
End Sub

Sub ShowConfig ()
  Dim A As String
  Dim B As String
  Dim C As String
  Dim D As String
  Dim E As String
  If OnLineFlag Then
    A = " (Online)"
  Else
    A = " (Offline)"
  End If
  B = "COM" + LTrim$(Str$(ThePort + 1))
  C = " @ " + BaudRateTable(TheBaudCode) + " "
  D = Str$(TheDataBits) + ParityText(TheParity)
  If TheStopBits = 0 Then
    E = "1"
  Else
    E = "2"
  End If
  MODEM.Caption = "MODEM: " + B + C + D + E + A
End Sub

